// VidSnap Chrome Extension - Background Service Worker

const VIDSNAP_URL = 'https://vidsnap.net';

// Listen for extension icon click (when popup is not available)
chrome.action.onClicked.addListener((tab) => {
  // This only fires if there's no popup defined
  // Since we have a popup, this won't normally fire
  chrome.tabs.create({ url: VIDSNAP_URL });
});

// Context menu for right-click on videos
chrome.runtime.onInstalled.addListener(() => {
  // Create context menu item
  chrome.contextMenus.create({
    id: 'vidsnap-download',
    title: 'Download video with VidSnap',
    contexts: ['video', 'link'],
    documentUrlPatterns: ['*://*.facebook.com/*', '*://*.fb.watch/*']
  });
  
  // Create context menu for page
  chrome.contextMenus.create({
    id: 'vidsnap-download-page',
    title: 'Download this page\'s video with VidSnap',
    contexts: ['page'],
    documentUrlPatterns: ['*://*.facebook.com/*', '*://*.fb.watch/*']
  });
});

// Handle context menu clicks
chrome.contextMenus.onClicked.addListener((info, tab) => {
  let videoUrl;
  
  if (info.menuItemId === 'vidsnap-download') {
    // Use the link URL or the source URL of the video
    videoUrl = info.linkUrl || info.srcUrl || info.pageUrl;
  } else if (info.menuItemId === 'vidsnap-download-page') {
    videoUrl = info.pageUrl;
  }
  
  if (videoUrl) {
    const encodedUrl = encodeURIComponent(videoUrl);
    chrome.tabs.create({
      url: `${VIDSNAP_URL}/?url=${encodedUrl}&source=extension`
    });
  }
});

// Listen for messages from content script
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'openVidSnap') {
    const encodedUrl = encodeURIComponent(request.url);
    chrome.tabs.create({
      url: `${VIDSNAP_URL}/?url=${encodedUrl}&source=extension`
    });
    sendResponse({ success: true });
  }
  return true;
});
