// VidSnap Chrome Extension - Popup Script

const VIDSNAP_URL = 'https://vidsnap.net';

// Check if URL is a Facebook video URL
function isFacebookVideoUrl(url) {
  if (!url) return false;
  const patterns = [
    /facebook\.com\/.*\/videos\//,
    /facebook\.com\/watch/,
    /facebook\.com\/reel/,
    /facebook\.com\/.*\/posts\//,
    /facebook\.com\/share\/v\//,
    /fb\.watch\//
  ];
  return patterns.some(pattern => pattern.test(url));
}

// Open VidSnap with the video URL
function openVidSnap(videoUrl) {
  const encodedUrl = encodeURIComponent(videoUrl);
  chrome.tabs.create({
    url: `${VIDSNAP_URL}/?url=${encodedUrl}&source=extension`
  });
}

// Initialize popup
async function init() {
  const statusFacebook = document.getElementById('statusFacebook');
  const statusNotFacebook = document.getElementById('statusNotFacebook');
  const currentUrlSection = document.getElementById('currentUrlSection');
  const downloadCurrentBtn = document.getElementById('downloadCurrentBtn');
  const downloadUrlBtn = document.getElementById('downloadUrlBtn');
  const urlInput = document.getElementById('urlInput');
  const openWebsiteBtn = document.getElementById('openWebsiteBtn');
  
  // Get current tab URL
  const [tab] = await chrome.tabs.query({ active: true, currentWindow: true });
  const currentUrl = tab?.url || '';
  
  // Check if we're on a Facebook video page
  if (isFacebookVideoUrl(currentUrl)) {
    statusFacebook.classList.remove('hidden');
    currentUrlSection.classList.remove('hidden');
    statusNotFacebook.classList.add('hidden');
    
    // Pre-fill the URL input
    urlInput.value = currentUrl;
    
    // Download current video button
    downloadCurrentBtn.addEventListener('click', () => {
      openVidSnap(currentUrl);
    });
  } else {
    statusNotFacebook.classList.remove('hidden');
    statusFacebook.classList.add('hidden');
    currentUrlSection.classList.add('hidden');
  }
  
  // Download from URL input
  downloadUrlBtn.addEventListener('click', () => {
    const url = urlInput.value.trim();
    if (url) {
      if (isFacebookVideoUrl(url)) {
        openVidSnap(url);
      } else {
        alert('Please enter a valid Facebook video URL.\n\nSupported formats:\n• facebook.com/watch\n• facebook.com/*/videos/*\n• facebook.com/reel/*\n• fb.watch/*');
      }
    } else {
      alert('Please paste a Facebook video URL.');
    }
  });
  
  // Handle Enter key in URL input
  urlInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter') {
      downloadUrlBtn.click();
    }
  });
  
  // Open website button
  openWebsiteBtn.addEventListener('click', () => {
    chrome.tabs.create({ url: VIDSNAP_URL });
  });
}

// Run initialization
document.addEventListener('DOMContentLoaded', init);
